package furny.swing.admin.statistics.chart;

import org.jfree.chart.JFreeChart;

/**
 * Interface for chart settings.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public interface IChartSettings {
  @Override
  public String toString();

  /**
   * Creates a chart for the given run id.
   * 
   * @param runId
   *          the run id
   * @return the new chart
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public JFreeChart createChart(long runId);

}
